/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.util.FileHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Type;

public class JsonHelper {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement readJson(File file) {
        JsonParser jsonParser = parser;
        synchronized (jsonParser) {
            try (BufferedReader reader = FileHelper.openReader(file);){
                JsonElement jsonElement = parser.parse((Reader)reader);
                return jsonElement;
            }
            catch (Exception e) {
                BNBGamingLib.libInstance.getLog().error("Failed to read Json file " + file.getName());
                e.printStackTrace();
                return null;
            }
        }
    }

    public static boolean writeJson(JsonElement e, File file) {
        return JsonHelper.writeJson(e, file, gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeJson(JsonElement e, File file, Gson gson) {
        Gson gson2 = gson;
        synchronized (gson2) {
            try (BufferedWriter writer = FileHelper.openWriter(file);){
                writer.write(gson.toJson(e));
                boolean bl = true;
                return bl;
            }
            catch (Exception e1) {
                BNBGamingLib.libInstance.getLog().error("Failed to write Json file " + file.getName());
                e1.printStackTrace();
                return false;
            }
        }
    }

    public static JsonElement toJsonTree(Object obj) {
        return JsonHelper.toJsonTree(obj, gson);
    }

    public static JsonElement toJsonTree(Object obj, Gson gson) {
        return gson.toJsonTree(obj);
    }

    public static boolean writeGson(Object obj, File file) {
        return JsonHelper.writeGson(obj, file, gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeGson(Object obj, File file, Gson gson) {
        Gson gson2 = gson;
        synchronized (gson2) {
            try (BufferedWriter writer = FileHelper.openWriter(file);){
                writer.write(gson.toJson(obj));
                boolean bl = true;
                return bl;
            }
            catch (Exception e1) {
                BNBGamingLib.libInstance.getLog().error("Failed to write Json file " + file.getName());
                e1.printStackTrace();
                return false;
            }
        }
    }

    public static <T> T readGson(Class<T> clazz, File file) {
        return JsonHelper.readGson(clazz, file, gson, false);
    }

    public static <T> T readGson(Class<T> clazz, File file, Gson gson) {
        return JsonHelper.readGson(clazz, file, gson, false);
    }

    public static <T> T readGson(Class<T> clazz, File file, boolean printStackTrace) {
        return JsonHelper.readGson(clazz, file, gson, printStackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readGson(Class<T> clazz, File file, Gson gson, boolean printStackTrace) {
        Gson gson2 = gson;
        synchronized (gson2) {
            try (BufferedReader reader = FileHelper.openReader(file);){
                Object object = gson.fromJson((Reader)reader, clazz);
                return (T)object;
            }
            catch (Exception e) {
                BNBGamingLib.libInstance.getLog().error("Failed to read Json from file " + file.getName());
                if (!printStackTrace) return null;
                e.printStackTrace();
                return null;
            }
        }
    }

    public static <T> T readGson(Type type, File file) {
        return JsonHelper.readGson(type, file, gson, false);
    }

    public static <T> T readGson(Type type, File file, boolean printStackTrace) {
        return JsonHelper.readGson(type, file, gson, printStackTrace);
    }

    public static <T> T readGson(Type type, File file, Gson gson) {
        return JsonHelper.readGson(type, file, gson, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readGson(Type type, File file, Gson gson, boolean printStackTrace) {
        Gson gson2 = gson;
        synchronized (gson2) {
            try (BufferedReader reader = FileHelper.openReader(file);){
                Object object = gson.fromJson((Reader)reader, type);
                return (T)object;
            }
            catch (Exception e) {
                BNBGamingLib.libInstance.getLog().error("Failed to read Json from file " + file.getName());
                if (!printStackTrace) return null;
                e.printStackTrace();
                return null;
            }
        }
    }
}

